% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPtree.R
\name{DPTreePosteriorMulti}
\alias{DPTreePosteriorMulti}
\title{D-P tree posterior updating from multiple copula observations.}
\usage{
DPTreePosteriorMulti(x, prior, w = 1)
}
\arguments{
\item{x}{An array of dimension n by 2. Multiple copula data observations,
with each row being a bivariate copula observation.
All elements should be between 0 and 1.}

\item{prior}{A list. Should be in same format as returned from  \code{DPTreePrior}.}

\item{w}{A positive number or an array of length n. Weight of data for posterior updating. Default 1.}
}
\value{
A list.
\item{a}{An array containing the hyperparameters of D-P trees.}
}
\description{
\code{DPTreePosteriorMulti} returns
the D-P tree posterior given input copula data.
}
\examples{
nsim = 10
rho = 0.9
data1 <- MASS::mvrnorm(n=nsim, mu=rep(0, 2), Sigma=matrix(c(1, rho, rho, 1), 2, 2))
data2 <- stats::pnorm(data1)
DPTreePosteriorMulti(x=data2, prior=DPTreePrior(m=4, z=1))
}
\references{
\insertRef{DPtree}{DPtree}
}
