% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_highdim.R
\name{cf_highdim}
\alias{cf_highdim}
\title{Plot 2D contour slices of higher dimensional functions}
\usage{
cf_highdim(
  func,
  D,
  low = rep(0, D),
  high = rep(1, D),
  baseline = (low + high)/2,
  same_scale = TRUE,
  n = 20,
  batchmax = 1,
  var_names = c(expression(), lapply(1:D, function(ti) bquote(x[.(ti)]))),
  pts = NULL,
  average = FALSE,
  average_reps = 10000,
  axes = TRUE,
  key.axes,
  key.title,
  nlevels = 20,
  levels = pretty(zlim, nlevels),
  color.palette = cm.colors.strong,
  col = color.palette(length(levels) - 1),
  edge_width = 0.04,
  cex.var_names = 1.3,
  bar = TRUE,
  ...
)
}
\arguments{
\item{func}{Function to plot contours of}

\item{D}{Input dimension of function}

\item{low}{Low input value for each dimension}

\item{high}{High input value for each dimension}

\item{baseline}{Baseline input value for each dimension}

\item{same_scale}{Should all contour plots be on the same scale?}

\item{n}{Number of points in grid on each dimension}

\item{batchmax}{number of datapoints that can be computed at a time}

\item{var_names}{Variable names to add to plot
Takes longer since it has to precalculate range of outputs.}

\item{pts}{Matrix of points to show on plot}

\item{average}{Should the background dimensions be averaged over instead of
set to baseline value? Much slower.}

\item{average_reps}{Number of points to average over when using average}

\item{axes}{logical indicating if axes should be drawn, as in plot.default.}

\item{key.axes}{statements which draw axes on the plot key. This overrides the default axis.}

\item{key.title}{statements which add titles for the plot key.}

\item{nlevels}{if levels is not specified, the range of z, values is
divided into approximately this many levels.}

\item{levels}{a set of levels which are used to partition the range of z.
Must be strictly increasing (and finite). Areas with z values between
consecutive levels are painted with the same color.}

\item{color.palette}{A color palette function to be used to assign colors
in the plot. Defaults to cm.colors.strong. Other options include rainbow,
heat.colors, terrain.colors, topo.colors, and function(x) \{gray((1:x)/x)\}.}

\item{col}{an explicit set of colors to be used in the plot.
This argument overrides any palette function specification.
There should be one less color than levels.}

\item{edge_width}{How wide should edges with variable names be? As proportion of full screen.}

\item{cex.var_names}{Size of var_names printed on edges.}

\item{bar}{Should a bar showing the output range and colors be shown on the top right?}

\item{...}{Arguments passed to cf_func, and then probably through to cf_grid}
}
\description{
Plots a grid of contour plots.
Each contour plot is a contour over two dimensions with the remaining
dimensions set to the baseline value.
Similar to plots created in Hwang et al. (2018).
}
\examples{
\dontrun{
# Only use 4 dims of 8 for borehole function
cf_highdim(function(x) TestFunctions::borehole(c(x,.5,.5,.5,.5)), 4)
# Add points
cf_highdim(function(x) TestFunctions::borehole(c(x,.5,.5,.5,.5)), 4,
           pts=matrix(c(.1,.3,.6,.9),1,4))

# Full 8D borehole function
cf_highdim(TestFunctions::borehole, 8)

# Putting each plot on separate scale
cf_highdim(TestFunctions::borehole, 8, n=10, same_scale = FALSE)
}

cf_highdim(function(x) {x[1]^2 + exp(x[2])}, D=3)

friedman <- function(x) {
  10*sin(pi*x[1]*x[2]) + 20*(x[3]-.5)^2 + 10*x[4] + 5*x[5]
}
cf_highdim(friedman, 5, color.palette=topo.colors)
cf_highdim(friedman, 5, 
           color.palette=function(x) {gray((1:x)/x)},
           nlevels=10)
           
\dontrun{
# Recreate Plate 1 or Figure 1.1 from Engineering Design via Surrogate
# Modelling by Forrester, Sobester, and Keane (2008).
cf_highdim(function(x)TestFunctions::wingweight(x, scale_it=FALSE),
  D=10, low = c(150,220,6,-10,16,.5,.08,2.5,1700,.025),
  high = c(200,300,10,10,45,1,.18,6,2500,.08),
  baseline=c(174,252,7.52,0,34,.672,.12,3.8,2000,.064),
  color.palette=topo.colors, 
  var_names=c('SW', 'Wtw', 'A', 'Lambda', 'q', 'lambda', 'tc', 'Nz', 'Wdg'))
}

# Average over background dimensions, use higher reps to reduce noise.
f1 <- function(x) {x[1] + x[2]^2 + x[3]^3}
cf_highdim(f1, 4, average=TRUE, average_reps=1e2, n=10)
f1b <- function(x) {x[,1] + x[,2]^2 + x[,3]^3}
cf_highdim(f1b, 4, average=TRUE, average_reps=1e2, n=10, batchmax=Inf)
cf_highdim(f1b, 4, average_reps=1e2, n=10, batchmax=Inf,
           color.palette = topo.colors, nlevels=3)

# This was giving bad result
csa()
split.screen(c(2,1))
screen(2)
cf_highdim(f1b, 4, n=10, batchmax=Inf)
csa()
}
\references{
Hwang, Yongmoon, Sang-Lyul Cha, Sehoon Kim, Seung-Seop Jin,
and Hyung-Jo Jung. "The Multiple-Update-Infill Sampling Method Using
Minimum Energy Design for Sequential Surrogate Modeling."
Applied Sciences 8, no. 4 (2018): 481.
}
