% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Singleblock_prediction.R
\name{predictboth}
\alias{predictboth}
\title{Prediction (clustering and target variable)}
\usage{
predictboth(x, u = NULL, result, np = FALSE)
}
\arguments{
\item{x}{covariates used for clustering}

\item{u}{covariates of the regression (can be null)}

\item{result}{results provided by function cluspred}

\item{np}{boolean indicating whether nonparametric estimation is used (TRUE) or not (FALSE)}
}
\value{
predictboth returns a list containing the predicted cluster membership (zhat) and the predicted value of the target variable (yhat).
}
\description{
Prediction for new observations
}
\examples{
require(ClusPred)
# data loading
data(simdata)

# mean regression with two latent groups in parametric framework and two covariates
res <- cluspred(simdata$y, simdata$x, simdata$u, K=2,
np=FALSE, nbCPU = 1, nbinit = 10)
# coefficient of the regression
res$param$beta
# proportions of the latent groups
res$param$pi
# posterior probability of the group memberships
head(res$tik)
# partition
res$zhat
# loglikelihood
res$loglike
# prediction (for possible new observations)
pred <- predictboth(simdata$x, simdata$u, res, np = FALSE)
# predicted cluster membreships
pred$zhat
# predicted value of the target variable
pred$yhat

\donttest{
# median regression with two latent groups in nonparametric framework and two covariates
res <- cluspred(simdata$y, simdata$x, simdata$u, K=2,
 model.reg = "quantile", tau = 0.5, nbinit = 10)
# coefficient of the regression
res$param$beta
# proportions of the latent groups
res$param$pi
# posterior probability of the group memberships
head(res$tik)
# partition
res$zhat
# smoothed loglikelihood
res$logSmoothlike
# prediction (for possible new observations)
pred <- predictboth(simdata$x, simdata$u, res, np = TRUE)
# predicted cluster membreships
pred$zhat
# predicted value of the target variable
pred$yhat
}


}
