% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocDownloadStats.R
\name{pkgDownloadRank}
\alias{pkgDownloadRank}
\title{What is a package's download rank?}
\usage{
pkgDownloadRank(
  pkg,
  pkgType = c("software", "data-experiment", "workflows", "data-annotation"),
  version = BiocManager::version()
)
}
\arguments{
\item{pkg}{character(1) The name of a Bioconductor package}

\item{pkgType}{character(1) One of 'software', 'data-experiment',
'workflows', or 'data-annotation' (defaults to 'software')}

\item{version}{(Optional) \code{character(1)} or \code{package_version}
indicating the \emph{Bioconductor} version (e.g., "3.8") for which
repositories are required.}
}
\value{
The package's percentile rank, in terms of download statistics, and
proportion in the name
}
\description{
This function uses \code{available.packages} to calculate the download rank
\emph{percentile} of a given package. It approximates what is observed
in the Bioconductor landing page.
}
\examples{

## Percentile rank for BiocGenerics (top 1\%)
pkgDownloadRank("BiocGenerics", "software")

}
