% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPkgDependencyGraph.R
\name{inducedSubgraphByPkgs}
\alias{inducedSubgraphByPkgs}
\title{Return a minimal subgraph based on package name(s)}
\usage{
inducedSubgraphByPkgs(g, pkgs, pkg_color = "red")
}
\arguments{
\item{g}{an igraph graph, typically created by
\code{\link{buildPkgDependencyIgraph}}}

\item{pkgs}{character() vector of packages to
include. Package names not included in
the graph are ignored.}

\item{pkg_color}{character(1) giving color of named
packages. Other packages in the graph that fall in
connecting paths will be colored as the igraph default.}
}
\description{
Find the subgraph induced by including
specific packages. The induced subgraph is
the graph that includes the named packages
and all edges connecting them. This is useful
for a developer, for example, to examine her packages
and their intervening dependencies.
}
\examples{
library(igraph)
g = buildPkgDependencyIgraph(buildPkgDependencyDataFrame())
g2 = inducedSubgraphByPkgs(g, pkgs=c('GenomicFeatures',
'TCGAbiolinksGUI', 'BiocGenerics', 'org.Hs.eg.db', 'minfi', 'limma'))
g2
V(g2)

plot(g2)

}
