% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocBuildReport.R
\name{biocBuildReport}
\alias{biocBuildReport}
\title{Tidy Bioconductor build report results}
\usage{
biocBuildReport(version = BiocManager::version(), stage.timings = FALSE)
}
\arguments{
\item{version}{character(1) the character version number
as used to access the online build report. For
example, "3.14". The default is the "current version"
as given by \code{BiocManager::version()}. Note
that this is a character vector of length one and not a number.}

\item{stage.timings}{logical(1) Whether to include the start, end, and
elapsed time for each build, check, install stage from each building in
the result (default: FALSE)}
}
\value{
A \code{tbl_df} object with columns pkg, version,
author, commit, date, node, stage, and result.
}
\description{
The online Bioconductor build reports
are great for humans to look at, but
they are not easily computable. This function
scrapes HTML and text files available
from the build report online pages to generate
a tidy data frame version of the build report.
}
\examples{

# Set the stage--what version of Bioc am I using?
BiocManager::version()

latest_build <- biocBuildReport()
head(latest_build)

}
