% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{DIC}
\alias{DIC}
\title{Deviance information criterion}
\usage{
DIC(sampler, ...)
}
\arguments{
\item{sampler}{An object of class bayesianOutput (mcmcSampler, smcSampler, or mcmcList)}

\item{...}{further arguments passed to \code{\link{getSample}}}
}
\description{
Deviance information criterion
}
\details{
Output:
list with the following elements: \cr
DIC   : Deviance Information Criterion \cr
IC    : Bayesian Predictive Information Criterion \cr
pD    : Effective number of parameters (pD = Dbar - Dhat) \cr
pV    : Effective number of parameters (pV = var(D)/2) \cr
Dbar  : Expected value of the deviance over the posterior \cr
Dhat  : Deviance at the mean posterior estimate \cr
}
\references{
Spiegelhalter, D. J.; Best, N. G.; Carlin, B. P. & van der Linde, A. (2002) Bayesian measures of model complexity and fit. J. Roy. Stat. Soc. B, 64, 583-639.\cr\cr
Gelman, A.; Hwang, J. & Vehtari, A. (2014) Understanding predictive information criteria for Bayesian models. Statistics and Computing, Springer US, 24, 997-1016-.
}
\seealso{
\code{\link{WAIC}}, \code{\link{MAP}}, \code{\link{marginalLikelihood}}
}
\author{
Florian Hartig
}
