% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFutils.R
\name{formatBF}
\alias{formatBF}
\title{Formatting of Bayes factors}
\usage{
formatBF(BF, digits = "default")
}
\arguments{
\item{BF}{Bayes factor}

\item{digits}{either \code{"default"} (see Details) or a positive integer
specifiying the number of decimal places to round the Bayes factor (for
Bayes factors \eqn{\geq 1}{>= 1}) or its inverse (for Bayes factors
\eqn{< 1}{< 1})}
}
\value{
A character vector of ratios (for inputs \eqn{< 1}{< 1}) or rounded
numeric values (for inputs \eqn{\geq 1}{>= 1}) ).
}
\description{
Formats Bayes factors such that Bayes factors smaller than 1 are
represented as ratios \eqn{1/x}, where \eqn{x} is rounded to the
specified number of digits, while Bayes factors larger than 1 are only
rounded to the specified number of digits.
}
\details{
The default formatting, which is recommended in Held and Ott (2018),
is as follows: For very small Bayes factors BF < 1/1000, "< 1/1000" is
returned. Bayes factors BF with 1/1000 \eqn{\leq}{<=} BF \eqn{\leq}{<=}
1/10 are formatted as \eqn{1/x} where \eqn{x} is an integer and Bayes
factors BF with \eqn{1/10} \eqn{<} BF \eqn{<} 1 as \eqn{1/x}, where
\eqn{x} is rounded to one decimal place. Accordingly, Bayes factors
\eqn{\leq}{<=} BF \eqn{<} 10 are rounded to one decimal place, Bayes
factors 10 \eqn{\leq}{<=} BF \eqn{\leq}{<=} 1000 are rounded to the next
integer and for larger Bayes factors, "> 1000" is returned.

If digits is specified, the Bayes factor (if it is \eqn{\geq}{>=} 1) or its
inverse (if the Bayes factor is \eqn{<} 1) is rounded to the number of
decimal places specified and returned as a ratio if the Bayes factor is
\eqn{<} 1.
}
\examples{
(bf <- BFr(to = 2, so = 0.5, tr = 2.5, sr = 0.9))
formatBF(BF = bf)

}
\references{
Held, L. and Ott, M. (2018). On \eqn{p}-values and Bayes factors.
Annual Review of Statistics and Its Application, 5, 393-419.
\doi{10.1146/annurev-statistics-031017-100307}
}
\author{
Manuela Ott (creator of package \code{pCalibrate}), Leonhard Held
(contributor of package \code{pCalibrate}), Samuel Pawel (made small
changes to \code{pCalibrate::formatBF})
}
