% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{lotka_volterra}
\alias{lotka_volterra}
\title{Lotka-Volterra System}
\usage{
lotka_volterra(n, init_conditions, dt, snr = Inf)
}
\arguments{
\item{n}{Number of time points (rounded to the nearest integer).}

\item{init_conditions}{Initial conditions as a numeric vector of length 2.}

\item{dt}{Time step between observations.}

\item{snr}{Signal-to-noise ratio (in dB). Use Inf for no noise.}
}
\value{
A numeric matrix representing the system's state over time. Each row
        corresponds to a time point, and each column represents a variable.
}
\description{
Simulates the Lotka-Volterra predator-prey system with optional noise.
}
\details{
This function simulates the Lotka-Volterra predator-prey system with the
specified parameters. It uses the specified time step and initial conditions
to compute the system's state over time. If a non-Infinite SNR is provided,
Gaussian noise is added to the system.
}
\examples{
# Simulate a Lotka-Volterra system with 100 time points and no noise
data <- lotka_volterra(
  n = 100,
  dt = 0.01,
  init_conditions = c(2, 1),
  snr = Inf
)

}
