#include "DensityMatrixSolvers.h"
#include "PSMatrix.h"
#include "SolverParameters.h"

////////////////////////////////////////////////////////////////////////////////
extern "C" {
#include "DensityMatrixSolvers_c.h"
}

////////////////////////////////////////////////////////////////////////////////
namespace NTPoly {
////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::PM(const Matrix_ps &Hamiltonian,
                              const Matrix_ps &Overlap, double trace,
                              Matrix_ps &Density, double &energy_value_out,
                              double &chemical_potential_out,
                              const SolverParameters &solver_parameters) {
  PM_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
         &energy_value_out, &chemical_potential_out, GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::TRS2(const Matrix_ps &Hamiltonian,
                                const Matrix_ps &Overlap, double trace,
                                Matrix_ps &Density, double &energy_value_out,
                                double &chemical_potential_out,
                                const SolverParameters &solver_parameters) {
  TRS2_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
           &energy_value_out, &chemical_potential_out,
           GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::TRS4(const Matrix_ps &Hamiltonian,
                                const Matrix_ps &Overlap, double trace,
                                Matrix_ps &Density, double &energy_value_out,
                                double &chemical_potential_out,
                                const SolverParameters &solver_parameters) {
  TRS4_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
           &energy_value_out, &chemical_potential_out,
           GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::HPCP(const Matrix_ps &Hamiltonian,
                                const Matrix_ps &Overlap, double trace,
                                Matrix_ps &Density, double &energy_value_out,
                                double &chemical_potential_out,
                                const SolverParameters &solver_parameters) {
  HPCP_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
           &energy_value_out, &chemical_potential_out,
           GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::DenseDensity(
    const Matrix_ps &Hamiltonian, const Matrix_ps &Overlap, double trace,
    Matrix_ps &Density, double &energy_value_out,
    double &chemical_potential_out, const SolverParameters &solver_parameters) {
  DenseDensity_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
                   &energy_value_out, &chemical_potential_out,
                   GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::ScaleAndFold(
    const Matrix_ps &Hamiltonian, const Matrix_ps &Overlap, double trace,
    Matrix_ps &Density, double homo, double lumo, double &energy_value_out,
    const SolverParameters &solver_parameters) {
  ScaleAndFold_wrp(GetIH(Hamiltonian), GetIH(Overlap), &trace, GetIH(Density),
                   &homo, &lumo, &energy_value_out, GetIH(solver_parameters));
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::EnergyDensityMatrix(const Matrix_ps &Hamiltonian,
                                               const Matrix_ps &Density,
                                               Matrix_ps &EnergyDensity,
                                               double threshold) {
  EnergyDensityMatrix_wrp(GetIH(Hamiltonian), GetIH(Density),
                          GetIH(EnergyDensity), &threshold);
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::McWeenyStep(const Matrix_ps &D, Matrix_ps &DOut,
                                       double threshold) {
  McWeenyStep_wrp(GetIH(D), GetIH(DOut), &threshold);
}

////////////////////////////////////////////////////////////////////////////////
void DensityMatrixSolvers::McWeenyStep(const Matrix_ps &D, const Matrix_ps &S,
                                       Matrix_ps &DOut, double threshold) {
  McWeenyStepS_wrp(GetIH(D), GetIH(DOut), GetIH(S), &threshold);
}

} // namespace NTPoly
