[comment {-*- tcl -*- doctools manpage}]
[vset VERSION 1.0.2]
[manpage_begin pt::peg::import n [vset VERSION]]
[include include/module.inc]
[titledesc {PEG Import}]
[require Tcl "8.5 9"]
[require snit]
[require fileutil::paths]
[require pt::peg]
[require pluginmgr]
[require pt::peg::import [opt [vset VERSION]]]
[description]
[include include/ref_intro.inc]

This package provides a manager for parsing expression grammars, with
each instance handling a set of plugins for the import of them from
other formats, i.e. their conversion from, for example [term peg],
[term container], [term json], etc.

[para]

It resides in the Import section of the Core Layer of Parser Tools,
and is one of the three pillars the management of parsing expression
grammars resides on.

[para][image arch_core_import][para]

The other two pillars are, as shown above

[list_begin enum]
[enum] [manpage {PEG Export}], and
[enum] [manpage {PEG Storage}]
[list_end]

[para]

For information about the data structure which is the major output of
the manager objects provided by this package see the section
[sectref {PEG serialization format}].

[para]

The plugin system of our class is based on the package
[package pluginmgr], and configured to look for plugins using

[list_begin enum]
[enum] the environment variable [var GRAMMAR_PEG_IMPORT_PLUGINS],
[enum] the environment variable [var GRAMMAR_PEG_PLUGINS],
[enum] the environment variable [var GRAMMAR_PLUGINS],
[enum] the path [file {~/.grammar/peg/import/plugin}]
[enum] the path [file {~/.grammar/peg/plugin}]
[enum] the path [file {~/.grammar/plugin}]
[enum] the path [file {~/.grammar/peg/import/plugins}]
[enum] the path [file {~/.grammar/peg/plugins}]
[enum] the path [file {~/.grammar/plugins}]
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PEG\IMPORT\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PEG\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PLUGINS"
[list_end]

The last three are used only when the package is run on a machine
using the Windows(tm) operating system.

[para]

The whole system is delivered with three predefined import plugins,
namely

[list_begin definitions]
[def container] See [manpage {PEG Import Plugin. From CONTAINER format}] for details.
[def json]      See [manpage {PEG Import Plugin. From JSON format}] for details.
[def peg]       See [manpage {PEG Import Plugin. From PEG format}] for details.
[list_end]

[para]

For readers wishing to write their own import plugin for some format,
i.e. [term {plugin writer}]s, reading and understanding the
[manpage {Parser Tools Impport API}] specification is an absolute
necessity, as it documents the interaction between this package and
its plugins in detail.

[section API]
[subsection {Package commands}]

[list_begin definitions]

[call [cmd ::pt::peg::import] [arg objectName]]

This command creates a new import manager object with an associated
Tcl command whose name is [arg objectName]. This [term object] command
is explained in full detail in the sections [sectref {Object command}]
and [sectref {Object methods}]. The object command will be created
under the current namespace if the [arg objectName] is not fully
qualified, and in the specified namespace otherwise.

[list_end]

[subsection {Object command}]

All objects created by the [cmd ::pt::peg::import] command have
the following general form:

[list_begin definitions]

[call [cmd objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the
exact behavior of the command.

See section [sectref {Object methods}] for the detailed
specifications.

[list_end]

[subsection {Object methods}]

[list_begin definitions]

[call [arg objectName] [method destroy]]

This method destroys the object it is invoked for.

[call [arg objectName] [method {import text}] [arg text] [opt [arg format]]]

This method takes the [arg text] and converts it from the specified
[arg format] to the canonical serialization of a parsing expression
grammar using the import plugin for the format. An error is thrown if
no plugin could be found for the format.

The serialization generated by the conversion process is returned as
the result of this method.

[para]

If no format is specified the method defaults to [const text].

[para]

The specification of what a [term canonical] serialization is can be
found in the section [sectref {PEG serialization format}].

[para]

The plugin has to conform to the interface documented in the
[manpage {Parser Tools Import API}] specification.

[call [arg objectName] [method {import file}] [arg path] [opt [arg format]]]

This method is a convenient wrapper around the [method {import text}]
method described by the previous item.

It reads the contents of the specified file into memory, feeds the
result into [method {import text}] and returns the resulting
serialization as its own result.

[call [arg objectName] [method {import object text}] [arg object] \
	[arg text] [opt [arg format]]]

This method is a convenient wrapper around the [method {import text}]
method described by the previous item.

It expects that [arg object] is an object command supporting a
[method deserialize] method expecting the canonical serialization of a
parsing expression grammar.

It imports the text using [method {import text}] and then feeds the
resulting serialization into the [arg object] via [method deserialize].

This method returns the empty string as it result.

[call [arg objectName] [method {import object file}] [arg object] \
	[arg path] [opt [arg format]]]

This method behaves like [method {import object text}], except that it
reads the text to convert from the specified file instead of being
given it as argument.

[call [arg objectName] [method includes]]

This method returns a list containing the currently specified paths to
use to search for include files when processing input.

The order of paths in the list corresponds to the order in which they
are used, from first to last, and also corresponds to the order in
which they were added to the object.

[call [arg objectName] [method {include add}] [arg path]]

This methods adds the specified [arg path] to the list of paths to use
to search for include files when processing input. The path is added
to the end of the list, causing it to be searched after all previously
added paths. The result of the command is the empty string.

[para]

The method does nothing if the path is already known.

[call [arg objectName] [method {include remove}] [arg path]]

This methods removes the specified [arg path] from the list of paths
to use to search for include files when processing input. The result
of the command is the empty string.

[para]

The method does nothing if the path is not known.

[call [arg objectName] [method {include clear}]]

This method clears the list of paths to use to search for include
files when processing input. The result of the command is the empty
string.

[list_end]

[include include/serial/pegrammar.inc]
[include include/serial/pexpression.inc]
[include include/feedback.inc]
[manpage_end]
