

#include <config.h>
#include <stdio.h>
#include "synchrolib.h"

/*********
 *
 *		  Synchronisation primitives
 *
 ********/

void sync_guard_init( sync_guard_t *guard, int init )
{
	pthread_mutexattr_t *p_attr = NULL;		
	pthread_mutex_init( &guard->mutex, p_attr );
	pthread_cond_init( &guard->cond, NULL );
	guard->predicate = init;
}

void sync_guard_test( sync_guard_t *guard)
{
	pthread_mutex_lock( &guard->mutex );
	while( !guard->predicate )
	{
		pthread_cond_wait( &guard->cond, &guard->mutex );
	}
	pthread_mutex_unlock( &guard->mutex );
}

void sync_guard_update( sync_guard_t *guard, int predicate )
{
	pthread_mutex_lock( &guard->mutex );
	guard->predicate = predicate;
	pthread_cond_broadcast( &guard->cond );
	pthread_mutex_unlock( &guard->mutex );
}

void mp_semaphore_init( mp_semaphore_t *sema, int init_count )
{
	pthread_mutexattr_t *p_attr = NULL;			
	pthread_mutex_init( &sema->mutex, p_attr );
	pthread_cond_init( &sema->raised, NULL );
	sema->count = init_count;
}

void mp_semaphore_wait( mp_semaphore_t *sema)
{
	pthread_mutex_lock( &sema->mutex );
	while( sema->count == 0 )
	{
		pthread_cond_wait( &sema->raised, &sema->mutex );
	}
	--(sema->count);
	pthread_mutex_unlock( &sema->mutex );
}

void mp_semaphore_signal( mp_semaphore_t *sema, int count )
{
	pthread_mutex_lock( &sema->mutex );
	sema->count += count;
	pthread_cond_broadcast( &sema->raised );
	pthread_mutex_unlock( &sema->mutex );
}

void mp_semaphore_set( mp_semaphore_t *sema )
{
	pthread_mutex_lock( &sema->mutex );
	sema->count = 1;
	pthread_cond_broadcast( &sema->raised );
	pthread_mutex_unlock( &sema->mutex );
}
