/* mpeg2enc.c, main() and parameter file reading                            */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */
/* Modifications and enhancements (C) 2000/2001 Andrew Stevens */

/* These modifications are free software; you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>

#include "global.h"
#include "motionsearch.h"
#include "format_codes.h"
#include "mpegconsts.h"
#include "fastintfns.h"
#include "../utils/altivec/altivec_conf.h"

#define MAX(a,b) ( (a)>(b) ? (a) : (b) )
#define MIN(a,b) ( (a)<(b) ? (a) : (b) )

#ifndef O_BINARY
# define O_BINARY 0
#endif


uint8_t *bufalloc( size_t size )
{
	char *buf = malloc( size + BUFFER_ALIGN );
	unsigned long adjust;

	if( buf == NULL ) { mjpeg_error_exit1("malloc failed"); }
	adjust = BUFFER_ALIGN - ((unsigned long)buf) % BUFFER_ALIGN;
	if( adjust == BUFFER_ALIGN ) adjust = 0;
	return (uint8_t*)(buf+adjust);
}

static void border_mark( uint8_t *frame, int w1, int h1, int w2, int h2)
{
  int i, j;
  uint8_t *fp;
  uint8_t mask = 0xff;
 
  for (j=0; j<h1; j++)
  {
    fp = frame + j*w2;
    for (i=w1; i<w2; i++) { fp[i] = mask; mask ^= 0xff; }
  }
 
  for (j=h1; j<h2; j++)
  {
    fp = frame + j*w2;
    for (i=0; i<w2; i++) { fp[i] = mask; mask ^= 0xff; }
  }
}

static int f_code( int max_radius )
{
	int c=5;
	if( max_radius < 64) c = 4;
	if( max_radius < 32) c = 3;
	if( max_radius < 16) c = 2;
	if( max_radius < 8) c = 1;
	return c;
}

static int quant_hfnoise_filt(int orgquant, int qmat_pos, int param_hf_quant )
{
	int orgdist = intmax(qmat_pos % 8, qmat_pos/8);
	int qboost = 1024;

	if( param_hf_quant != 1) return orgquant;

	/* Maximum 150% quantisation boost for HF components... */
	qboost = 256+(384/8)*orgdist;

	return (orgquant * qboost)/ 256;
}


void reencode(	int param_hf_quant,
				int param_22_red,
				int param_44_red,
				int param_searchrad,
				int param_quant,
				double param_fact_x,
				int param_num_cpus,
				long long param_origm2vsize )
{
	int i, n, q, v;
	static int block_count_tab[3] = {6,8,12};
    int enc_chrom_width, enc_chrom_height;
	
	mjpeg_default_handler_verbosity(0);

	istrm_fd = 0; /*stdin*/
	outfile = stdout;
	inputtype = 0;
	istrm_nframes = 999999999;
	ibitcount = 0;
	
	origm2vsize = param_origm2vsize;
	
	/* Read parameters inferred from input stream */
	init_read();
	read_stream_params (	&opt_horizontal_size,
							&opt_vertical_size, /* frame size (pels) */
							&opt_aspectratio, /* aspect ratio information (pel or display) */
							&opt_frame_rate_code, /* coded value of playback display frame rate */
							&opt_video_format, /* component, PAL, NTSC, SECAM or MAC */
							&opt_color_primaries, /* source primary chromaticity coordinates */
							&opt_transfer_characteristics, /* opto-electronic transfer char. (gamma) */
							&opt_matrix_coefficients, /* Eg,Eb,Er / Y,Cb,Cr matrix coefficients */
							&opt_display_horizontal_size, 
							&opt_display_vertical_size, /* display size */
							&opt_profile,
							&opt_level /* syntax / parameter constraints */
							);

	ctl_M				= 5;
	opt_fact_x			= param_fact_x;
	opt_prog_seq		= 0;
	opt_dctsatlim		= 2047;
	opt_vbv_buffer_code = 112;
	opt_vbv_buffer_size = opt_vbv_buffer_code*16384;
	ctl_quant		= (double)  param_quant;
	opt_seq_hdr_every_gop= 1;
	opt_svcd_scan_data	= 0;
	opt_low_delay		= 0;
	opt_chroma_format	= CHROMA420;
	opt_dc_prec			= 1;
	
	{ 
		int radius_x = param_searchrad;
		int radius_y = param_searchrad*opt_vertical_size/opt_horizontal_size;

		opt_motion_data = (struct motion_data *)malloc(ctl_M*sizeof(struct motion_data));
		if (!opt_motion_data) mjpeg_error_exit1("malloc failed");

		for (i=0; i<ctl_M; i++)
		{
			if(i==0)
			{
				opt_motion_data[i].sxf = round_search_radius(radius_x*ctl_M);
				opt_motion_data[i].syf = round_search_radius(radius_y*ctl_M);
				opt_motion_data[i].forw_hor_f_code  = f_code(opt_motion_data[i].sxf);
				opt_motion_data[i].forw_vert_f_code  = f_code(opt_motion_data[i].syf);
			}
			else
			{
				opt_motion_data[i].sxf = round_search_radius(radius_x*i);
				opt_motion_data[i].syf = round_search_radius(radius_y*i);
				opt_motion_data[i].sxb = round_search_radius(radius_x*(ctl_M-i));
				opt_motion_data[i].syb = round_search_radius(radius_y*(ctl_M-i));
				opt_motion_data[i].forw_hor_f_code  = f_code(opt_motion_data[i].sxf);
				opt_motion_data[i].forw_vert_f_code  = f_code(opt_motion_data[i].syf);
				opt_motion_data[i].back_hor_f_code  = f_code(opt_motion_data[i].sxb);
				opt_motion_data[i].back_vert_f_code  = f_code(opt_motion_data[i].syb);
			}
		}
	}


	/* search windows */
	for (i=0; i<ctl_M; i++)
	{
		if (opt_motion_data[i].sxf > (4<<opt_motion_data[i].forw_hor_f_code)-1)
			opt_motion_data[i].sxf = (4<<opt_motion_data[i].forw_hor_f_code)-1;

		if (opt_motion_data[i].syf > (4<<opt_motion_data[i].forw_vert_f_code)-1)
			opt_motion_data[i].syf = (4<<opt_motion_data[i].forw_vert_f_code)-1;

		if (i!=0)
		{
			if (opt_motion_data[i].sxb > (4<<opt_motion_data[i].back_hor_f_code)-1)
				opt_motion_data[i].sxb = (4<<opt_motion_data[i].back_hor_f_code)-1;

			if (opt_motion_data[i].syb > (4<<opt_motion_data[i].back_vert_f_code)-1)
				opt_motion_data[i].syb = (4<<opt_motion_data[i].back_vert_f_code)-1;
		}
	}

	opt_load_iquant = 0;
	opt_load_niquant = 0;

	/* bufalloc to ensure alignment */
	opt_intra_q = (uint16_t*)bufalloc(64*sizeof(uint16_t));
	opt_inter_q = (uint16_t*)bufalloc(64*sizeof(uint16_t));
	i_intra_q = (uint16_t*)bufalloc(64*sizeof(uint16_t));
	i_inter_q = (uint16_t*)bufalloc(64*sizeof(uint16_t));

	if( param_hf_quant == 2)
	{
		opt_load_iquant |= 1;
		for (i=0; i<64; i++) opt_intra_q[i] = hires_intra_quantizer_matrix[i];
	}
	else
	{
		opt_load_iquant = (param_hf_quant == 1);
		for (i=0; i<64; i++)
		{
			v = quant_hfnoise_filt( default_intra_quantizer_matrix[i], i, param_hf_quant);
			if (v<1 || v>255) mjpeg_error_exit1("value in intra quant matrix invalid (after noise filt adjust)");
			opt_intra_q[i] = v;
		} 
	}

	if( param_hf_quant == 2 )
		for (i=0; i<64; i++) opt_inter_q[i] = hires_nonintra_quantizer_matrix[i];
	else
	{
		opt_load_niquant |= (param_hf_quant == 1);
		for (i=0; i<64; i++)
		{
			v = quant_hfnoise_filt(default_nonintra_quantizer_matrix[i],i, param_hf_quant);
			if (v<1 || v>255) mjpeg_error_exit1("value in non-intra quant matrix invalid (after noise filt adjust)");
			opt_inter_q[i] = v;
		}
	}
  
	for (i=0; i<64; i++)
	{
		i_intra_q[i] = (int)(((double)IQUANT_SCALE) / ((double)opt_intra_q[i]));
		i_inter_q[i] = (int)(((double)IQUANT_SCALE) / ((double)opt_inter_q[i]));
	}

	for( q = 1; q <= 112; ++q )
	{
		for (i=0; i<64; i++)
		{
			intra_q_tbl[q][i] = opt_intra_q[i] * q;
			inter_q_tbl[q][i] = opt_inter_q[i] * q;
			intra_q_tblf[q][i] = (float)intra_q_tbl[q][i];
			inter_q_tblf[q][i] = (float)inter_q_tbl[q][i];
			i_intra_q_tblf[q][i] = 1.0f/ ( intra_q_tblf[q][i] * 0.98);
			i_intra_q_tbl[q][i] = (IQUANT_SCALE/intra_q_tbl[q][i]);
			i_inter_q_tblf[q][i] =  1.0f/ (inter_q_tblf[q][i] * 0.98);
			i_inter_q_tbl[q][i] = (IQUANT_SCALE/inter_q_tbl[q][i] );
		}
	}

	ctl_max_encoding_frames = param_num_cpus;
	ctl_refine_from_rec		= true;
	ctl_parallel_read		= true;
	ctl_44_red				= param_22_red;
	ctl_22_red				= param_44_red;
	
	mb_width = (opt_horizontal_size+15)/16;
	mb_height = opt_prog_seq ? (opt_vertical_size+15)/16 : 2*((opt_vertical_size+31)/32);
	
	opt_enc_width = 16*mb_width;
	opt_enc_height = 16*mb_height;
	opt_phy_width = (opt_enc_width + 63) & (~63);
	opt_phy_height = opt_enc_height;

	opt_phy_chrom_width = opt_phy_width>>1;
	opt_phy_chrom_height = opt_phy_height>>1;
	enc_chrom_width = opt_enc_width>>1;
	enc_chrom_height = opt_enc_height>>1;

	mb_height2 = mb_height;
	opt_phy_width2 = opt_phy_width;
	opt_phy_chrom_width2 = opt_phy_chrom_width;
 
	block_count = block_count_tab[opt_chroma_format-1];
	lum_buffer_size = (opt_phy_width*opt_phy_height) +
					 sizeof(uint8_t) *(opt_phy_width/2)*(opt_phy_height/2) +
					 sizeof(uint8_t) *(opt_phy_width/4)*(opt_phy_height/4+1);
	chrom_buffer_size = opt_phy_chrom_width*opt_phy_chrom_height;

	fsubsample_offset = (opt_phy_width)*(opt_phy_height) * sizeof(uint8_t);
	qsubsample_offset =  fsubsample_offset + (opt_phy_width/2)*(opt_phy_height/2)*sizeof(uint8_t);

	mb_per_pict = mb_width*mb_height2;

	/* clip table */
	if (!(clp_0_255 = (uint8_t *)malloc(1024))) mjpeg_error_exit1("malloc failed");
	clp_0_255 += 384;
	for (i=-384; i<640; i++) clp_0_255[i] = (i<0) ? 0 : ((i>255) ? 255 : i);
	
	/* Allocate the frame data buffers */
	frame_buffer_size = 30 + ctl_M + READ_CHUNK_SIZE + 1;
	frame_buffers = (uint8_t ***) bufalloc(frame_buffer_size*sizeof(uint8_t**));
	
	for(n=0;n<frame_buffer_size;n++)
	{
         frame_buffers[n] = (uint8_t **) bufalloc(3*sizeof(uint8_t*));
		 for (i=0; i<3; i++)
			 frame_buffers[n][i] = bufalloc( (i==0) ? lum_buffer_size : chrom_buffer_size );

         border_mark(frame_buffers[n][0],
                     opt_enc_width,opt_enc_height,
                     opt_phy_width,opt_phy_height);
         border_mark(frame_buffers[n][1],
                     enc_chrom_width, enc_chrom_height,
                     opt_phy_chrom_width,opt_phy_chrom_height);
         border_mark(frame_buffers[n][2],
                     enc_chrom_width, enc_chrom_height,
                     opt_phy_chrom_width,opt_phy_chrom_height);
	}
	
	/* other modules */
	initbits(); 
	init_fdct();
	init_idct();
	init_quantizer();
	init_motion();
	init_transform();
	init_predict();
	
	putseq();
}



